﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using DotNet.FrameWork.Data;
using System.Data;
using System.Data.SqlClient;
using HaTeam.Dd.Model;
using GetCommand;

namespace HteamDd.Web.Web.Dd_Attention
{
    public partial class Dd_Attention_Manage : System.Web.UI.Page
    {
        string[] user = null;
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                if (Session["user_Message"] != null)
                {
                    user = Session["user_Message"].ToString().Split(',');
                    BindAttention();
                }
            }
        }
        /// <summary>
        /// 绑定关联用户
        /// </summary>
        private void BindAttention()
        {

            this.Rpt_Attention.DataSource = GetAttentionByUserID(user[0]);//根据用户ID
            this.Rpt_Attention.DataBind();
        }
        /// <summary>
        /// 获得关注的个数
        /// </summary>
        /// <returns></returns>
        public int Count()
        {
            GetCount gc = new GetCount();
            return gc.BindCount(user[0]);
        }
        /// <summary>
        /// 获取与关注本用户的用户
        /// </summary>
        /// <param name="userid">本用户的id</param>
        /// <returns></returns>
        public List<Dd_Attention_Manange> GetAttentionByUserID(string userid)
        {
            string sql = "select * from Dd_Attention where Attention_UerID=" + userid;
            try
            {
                SqlDataReader dr = SqlHelper.ExecuteReader(CommandType.Text, sql, null);
                List<Dd_Attention_Manange> listdm = new List<Dd_Attention_Manange>();
                while (dr.Read())
                {
                    Dd_Attention_Manange dam = new Dd_Attention_Manange();

                    dam.Attented_By_user = Convert.ToInt32(dr["Attented_By_user"]);
                    dam.Attention_BlackList = Convert.ToInt32(dr["Attention_BlackList"]);
                    dam.Attention_Count = Convert.ToInt32(dr["Attention_Count"]);
                    dam.Attention_Datetime = Convert.ToDateTime(dr["Attention_Datetime"]);
                    dam.Attention_Delete = Convert.ToInt32(dr["Attention_Delete"]);
                    dam.Attention_Guid = dr["Attention_Guid"].ToString();
                    dam.Attention_ID = Convert.ToInt32(dr["Attention_ID"]);
                    dam.Attention_Lock = Convert.ToInt32(dr["Attention_Lock"]);
                    dam.Attention_Order = Convert.ToInt32(dr["Attention_Order"]);
                    dam.Attention_Remark = dr["Attention_Remark"].ToString();
                    dam.Attention_State = Convert.ToInt32(dr["Attention_State"]);
                    dam.Attention_UerID = Convert.ToInt32(dr["Attention_UerID"]);
                    dam.Attention_UpDatetime = Convert.ToDateTime(dr["Attention_UpDatetime"]);
                    dam.Attention_Verify = Convert.ToInt32(dr["Attention_Verify"]);
                    dam.Attention_UserName = UserName(dr["Attented_By_user"].ToString());
                    listdm.Add(dam);
                }
                return listdm;
            }
            catch
            {
                return null;
            }
        }
        /// <summary>
        /// 获取用户的博客名称
        /// </summary>
        /// <param name="userid"></param>
        /// <returns></returns>
        public string UserName(string userid)
        {
            string sql = "select User_BlogName from Dd_User where User_ID=@UserID";
            string User_BlogName;
            try
            {
                User_BlogName = SqlHelper.ExecuteScalar(CommandType.Text, sql, new SqlParameter("@UserID", userid)).ToString();
            }
            catch
            {
                User_BlogName = "";
            }
            return User_BlogName;
        }
    }
}